import { requireAdmin, adminError } from "@/lib/admin";
import { addGuests } from "@/lib/store";

export async function POST(req, { params }) {
  if (!requireAdmin(req)) return adminError();
  const { eventId } = params;
  const body = await req.json();
  const guests = Array.isArray(body.guests) ? body.guests : [];
  const created = await addGuests(eventId, guests);
  return new Response(JSON.stringify({ createdCount: created.length, created }), {
    headers: { "content-type": "application/json" },
  });
}
